import { Callbacks, Mode, Status } from "@elevenlabs/types";
import type { BaseConnection, SessionConfig, FormatConfig } from "./utils/BaseConnection";
import type { AgentAudioEvent, AgentChatResponsePartEvent, AgentResponseEvent, ClientToolCallEvent, InternalTentativeAgentResponseEvent, InterruptionEvent, UserTranscriptionEvent, VadScoreEvent, MCPToolCallClientEvent, AgentToolResponseEvent, ConversationMetadataEvent, AsrInitiationMetadataEvent, MCPConnectionStatusEvent, ErrorMessageEvent } from "./utils/events";
import type { InputConfig } from "./utils/input";
import type { OutputConfig } from "./utils/output";
export type { Role, Mode, Status, Callbacks } from "@elevenlabs/types";
/** Allows self-hosting the worklets to avoid whitelisting blob: and data: in the CSP script-src  */
export type AudioWorkletConfig = {
    workletPaths?: {
        rawAudioProcessor?: string;
        audioConcatProcessor?: string;
    };
    libsampleratePath?: string;
};
export type Options = SessionConfig & Callbacks & ClientToolsConfig & InputConfig & OutputConfig & AudioWorkletConfig;
export type PartialOptions = SessionConfig & Partial<Callbacks> & Partial<ClientToolsConfig> & Partial<InputConfig> & Partial<OutputConfig> & Partial<FormatConfig> & Partial<AudioWorkletConfig>;
export type ClientToolsConfig = {
    clientTools: Record<string, (parameters: any) => Promise<string | number | void> | string | number | void>;
};
export declare class BaseConversation {
    protected readonly options: Options;
    protected readonly connection: BaseConnection;
    protected lastInterruptTimestamp: number;
    protected mode: Mode;
    protected status: Status;
    protected volume: number;
    protected currentEventId: number;
    protected lastFeedbackEventId: number;
    protected canSendFeedback: boolean;
    protected static getFullOptions(partialOptions: PartialOptions): Options;
    protected constructor(options: Options, connection: BaseConnection);
    endSession(): Promise<void>;
    private endSessionWithDetails;
    protected handleEndSession(): Promise<void>;
    protected updateMode(mode: Mode): void;
    protected updateStatus(status: Status): void;
    protected updateCanSendFeedback(): void;
    protected handleInterruption(event: InterruptionEvent): void;
    protected handleAgentResponse(event: AgentResponseEvent): void;
    protected handleUserTranscript(event: UserTranscriptionEvent): void;
    protected handleTentativeAgentResponse(event: InternalTentativeAgentResponseEvent): void;
    protected handleVadScore(event: VadScoreEvent): void;
    protected handleClientToolCall(event: ClientToolCallEvent): Promise<void>;
    protected handleAudio(event: AgentAudioEvent): void;
    protected handleMCPToolCall(event: MCPToolCallClientEvent): void;
    protected handleMCPConnectionStatus(event: MCPConnectionStatusEvent): void;
    protected handleAgentToolResponse(event: AgentToolResponseEvent): void;
    protected handleConversationMetadata(event: ConversationMetadataEvent): void;
    protected handleAsrInitiationMetadata(event: AsrInitiationMetadataEvent): void;
    protected handleAgentChatResponsePart(event: AgentChatResponsePartEvent): void;
    protected handleErrorEvent(event: ErrorMessageEvent): void;
    private onMessage;
    private onError;
    getId(): string;
    isOpen(): boolean;
    setVolume: ({ volume }: {
        volume: number;
    }) => void;
    setMicMuted(isMuted: boolean): void;
    getInputByteFrequencyData(): Uint8Array;
    getOutputByteFrequencyData(): Uint8Array;
    getInputVolume(): number;
    getOutputVolume(): number;
    sendFeedback(like: boolean): void;
    sendContextualUpdate(text: string): void;
    sendUserMessage(text: string): void;
    sendUserActivity(): void;
    sendMCPToolApprovalResult(toolCallId: string, isApproved: boolean): void;
}
